;
;								EJEMPLO 21
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El teclado y el LCD.
;
;Haciendo uso de las rutinas incluidas en los ficheros TECLADO.INC y LCD_CXX.INC, se trata 
;de leer el teclado y, visualizar sobre el mdulo LCD  la tecla pulsada.
;
;El ejemplo pretende mostrar la interrupcin por cambio de estado en cualquiera de las lneas RB4-RB7 del PIC
;el sistema se mantiene en el modo SLEEP de bajo consumo y slo reacciona cuando tiene lugar la pulsacin
;de cualquier tecla.

		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                 
Lcd_var		equ	0x20		;Inicio de las variables para el LCD
Key_var		equ	0x22		;Inicio de las variables del teclado				
Temporal_1	equ	0x28		;Variable temporal n 1
Temporal_2	equ	0x29		;Variable temporal n 2
Temporal_3	equ	0x2a		;Variable temporal n 3
	
				org	0x00		;Vector de RESET	
				goto	Inicio
				org	0x04
				goto	Interrupcion	;Vector de interrupcin
				org	0x05
				
				include	"LCD_CXX.INC"	;Incluir rutinas de manejo del LCD
				include	"TECLADO.INC"	;Incluir rutinas de manejo del teclado

Tabla_Mensajes:	movwf	PCL				;Desplazamiento sobre la tabla

Mens_0			equ	$					;Mens_0 apunta al primer carcter
				dt	"Se ha pulsado: ",0x00

;*************************************************************************************
;Mensaje: Esta rutina visualiza en el LCD el mensaje cuyo inicio est indicado en
;el acumulador. El fin de un mensaje se determina mediante el cdigo 0x00

Mensaje         movwf   Temporal_1      ;Salva posicin de la tabla
Mensaje_1       movf    Temporal_1,W    ;Recupera posicin de la tabla
                call    Tabla_Mensajes  ;Busca caracter de salida
                movwf   Temporal_2      ;Guarda el caracter
                movf    Temporal_2,F
                btfss   STATUS,Z        ;Mira si es el ltimo
                goto    No_es_ultimo
                return
No_es_ultimo    call   	LCD_DATO        ;Visualiza en el LCD
                incf   	Temporal_1,F    ;Siguiente caracter
                goto   	Mensaje_1

;Programa de tratamiento de la interrupcin por cambio de estado							

Interrupcion	bcf		INTCON,RBIE		;Desactiva mascara RBIE
				call	Key_Scan		;Explora el teclado
				movf	Tecla,W
				movwf	Temporal_3		;Salva la tecla temporalmente

Inter_1			call	Key_Scan		;Explora el teclado
				movlw	0x80
				subwf	Tecla,W
				btfss	STATUS,Z		;Se ha liberado la tecla pulsada ?
				goto	Inter_1			;No, esperar que se libere

				call	UP_LCD			;Configura Puertas A y B como salidas para manejo del LCD		
				movlw	0x8f
				call	LCD_REG			;Posiciona el cursor del LCD
				movf	Temporal_3,W	;Recupera la tecla que se puls
				sublw	.9
				btfss	STATUS,C       	;Es mayor que 9 (A, B,C,D,E,F)?
				goto	Mayor_que_9		;Si
				movf	Temporal_3,W	;No
				addlw	0x30           	;Ajuste ASCII de los caracteres del 0 al 9
				call	LCD_DATO		;Visualizar sobre el LCD
				goto	Inter_Fin												
Mayor_que_9		movf	Temporal_3,W
				addlw	0x37			;Ajuste ASCII de los caracteres de la A a la F
				call	LCD_DATO       	;Visualiza sobre el LCD

Inter_Fin		clrf	PORTA
				clrf	PORTB
				bsf		STATUS,RP0		;Selecciona banco 1
				movlw	b'11110000'
				movwf	TRISB			;RB0-RB3 salidas, RB4-RB7 entradas
				nop
				nop						;Tiempo de espera para estabilizar la puerta B
				bcf		STATUS,RP0		;Selecciona banco 0	
				bcf		INTCON,RBIE		;Desconecta mscara de interrupcin RBIE
				movf	PORTB,W			;Lee estado actual de reposo de las entradas
				bcf		INTCON,RBIF		;Reponer el flag de interrupcin
				bsf		INTCON,RBIE		;Activa mscara de interrupcin RBIE
				retfie

Inicio:			bsf		STATUS,RP0		;Selecciona pgina 1 de datos
				movlw	0x06
				movwf	ADCON1			;Puerta A digital
				movlw	b'00000111'
				movwf	OPTION_REG		;Activa Pull-Up para las entradas de la puerta B
				bcf		STATUS,RP0		;Selecciona pgina 0 de datos		
				call	UP_LCD			;Configura Puerta A y B como salidas
				call	LCD_INI			;Rutina de inicializacin del LCD
				movlw	b'00001100'
				call	LCD_REG			;LCD en ON
				movlw	b'00000001'
				call	LCD_REG			;Borra LCD y HOME

;Salida del mensaje "Tecla pulsada:"
				
				movlw	Mens_0
				call	Mensaje			;Visualiza el mensaje		
				clrf	PORTA
				clrf	PORTB
				bsf		STATUS,RP0		;Selecciona banco 1
				movlw	b'11110000'
				movwf	TRISB			;RB0-RB3 salidas, RB4-RB7 entradas
				nop
				nop						;Tiempo de espera para estabilizar la puerta B
				bcf		STATUS,RP0		;Selecciona banco 0
				bcf		INTCON,RBIE		;Desconecta mscara de interrupcin RBIE
				movf	PORTB,W			;Lee estado actual de reposo de las entradas
				bcf		INTCON,RBIF		;Reponer el flag de interrupcin
				bsf		INTCON,RBIE		;Activa mscara de interrupcin RBIE
				bsf		INTCON,GIE		;Activa interrupciones

;Bucle principal

Loop:			sleep
				nop
				goto	Loop	

				end						;Fin del programa fuente
